import React from "react";
import { BrowserRouter, Route, Routes } from "react-router-dom";
import { Login } from "./pages/Login";
import { Register } from "./pages/Register";
import { Employee } from "./pages/Employee";
import { Dashboard } from "./pages/admin/Dashboard";

export const App = () => {
  const token = localStorage.getItem("token");
  let role = null;
  if (token) {
    try {
      role = JSON.parse(atob(token.split(".")[1])).role;
    } catch (e) {
      console.error("Invalid token", e);
    }
  }
  return (
    <>
      <BrowserRouter>
        <Routes>
          <Route path="/login" element={<Login />} />
          <Route path="/register" element={<Register />} />
          {role === "admin" ? (
            <Route path="/" element={<Dashboard />} />
          ) : (
            <Route path="/" element={<Employee />} />
          )}
        </Routes>
      </BrowserRouter>
    </>
  );
};
